<?php /* Template name: Home */ ?>

<?php get_header(); ?>



<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 my-slider">
	<div class="flexslider">
		<?php
			query_posts(array('post_type' => 'slider','orderby' => 'ASC')); ?>

			<ul class="slides">
				<?php while (have_posts()) : the_post();

				   $url = wp_get_attachment_url( get_post_thumbnail_id($post->ID) ); ?>

				   	<li style="background-image: url(<?php echo $url; ?>);">
				    	<div class="content">
				   			<?php the_content(); ?>
				   		</div>

				   </li>

				<?php endwhile; ?>
			</ul>
	</div>
</div>

<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 services-cols row-height row-xs-height row-sm-height row-md-height row-lg-height">
	<?php query_posts(array('post_type' => 'services','posts_per_page' => '6','order' => 'ASC', 'orderby' => 'menu_order'  ));
		while(have_posts()) : the_post(); ?>
			<div class="col-xs-6 xol-sm-6 col-md-2 col-lg-2 service-single-col col-height col-xs-height col-sm-height col-md-height col-lg-height
			col-middle col-xs-middle col-sm-middle col-md-middle col-lg-middle" style="background: <?php echo esc_attr( get_post_meta( $post->ID, 'gradient-color', true ) ); ?> ;
    			background: -moz-linear-gradient(<?php echo esc_attr( get_post_meta( $post->ID, 'gradient-color', true ) ); ?>, <?php echo esc_attr( get_post_meta( $post->ID, 'gradient-color1', true ) ); ?>);
    			background: linear-gradient(<?php echo esc_attr( get_post_meta( $post->ID, 'gradient-color', true ) ); ?>, <?php echo esc_attr( get_post_meta( $post->ID, 'gradient-color1', true ) ); ?>);">

    			<div class="inside">

	    			<h6 class="ptSansWhite"><?php echo esc_attr( get_post_meta( $post->ID, 'header-title', true ) ); ?></h6>

					<a href="<?php echo the_permalink(); ?>">
						<?php the_post_thumbnail('post-thumbnail', array( 'class' => "img-responsive", 'alt' => esc_attr( get_post_meta( $post->ID, 'header-title', true ) ))); ?>
					</a>

					<p class="productCopyWhiteDrop">
						<?php echo esc_attr( get_post_meta( $post->ID, 'bottom-desc', true ) ); ?>
					</p>

				</div>
			</div>
  <?php endwhile; ?>
</div>



<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 about-us about-row">
	<div class="col-xs-12 col-sm-12 col-md-5 col-lg-5 cellShadow my-about">
		<?php
			$args = array(
			'posts_per_page'   => 1,
			'category'         => 'about-us',
			'category_name'    => 'about-us',
			'post_type'        => 'post',
			'post_status'      => 'publish',
			'suppress_filters' => true
		);

		$loop = new WP_Query( $args );

		while ( $loop->have_posts() ) : $loop->the_post();?>
			<h5 class="ptSansWhiteBanner"><?php the_title(); ?></h5>
			<div class="testimonialBlue about-content">
				<?php the_content(); ?>
			</div>
  <?php endwhile;?>
	</div>

	<div class="col-xs-12 col-sm-12 col-md-4 col-lg-4 reviews cellShadow">
		<h5 class="ptSansWhiteBanner">Reviews</h5>
		<?php query_posts( array( 'post_type' => 'reviews', 'posts_per_page'   => 4, 'order' => 'ASC'	) ); ?>
	  		<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
					<div class="testimonialBlue about-content"><?php the_content();  ?> </div>
	  			<?php endwhile;
	  		endif;?>
			<a href="<?php echo get_permalink( get_page_by_path( 'review' ) ); ?>" class="review-btn">
				Leave Review
			</a>
	</div>
	<div class="col-xs-12 col-sm-12 col-md-3 col-lg-3 cellShadow sidebar">
		<?php if ( is_active_sidebar( 'right' ) ) : ?>
		    <?php dynamic_sidebar( 'right' ); ?>
		<?php endif; ?>
	</div>
</div>
<script type="text/javascript" charset="utf-8">
    jQuery('.flexslider').flexslider({
    	controlNav: false,
    	directionNav: false
    });
</script>
<?php get_footer(); ?>
