<?php

/*

 * 	Registers a service custom post type. 

 */

function prefix_register_slider_post_type()

{

	register_post_type(

		'slider',

		array(

			'labels'        => array(

			'name'               => __('Slider', 'text_domain'),

			'singular_name'      => __('Slider', 'text_domain'),

			'menu_name'          => __('Slider', 'text_domain'),

			'name_admin_bar'     => __('Slider', 'text_domain'),

			'all_items'          => __('All Sliders', 'text_domain'),

			'add_new'            => __('Add New Slide', 'prefix_portfolio', 'text_domain'),

			'add_new_item'       => __('Add New Slider Item', 'text_domain'),

			'edit_item'          => __('Edit Slider Items', 'text_domain'),

			'new_item'           => __('New Slider', 'text_domain'),

			'view_item'          => __('View Slider', 'text_domain')

			),

			'public'        => true,

			'menu_position' => 5,			

			'supports'      => array(

				'title',

				'editor',				

				'thumbnail',

				'excerpt',

				'page-attributes',

				),

			

			'has_archive'   => true,

			'rewrite'       => array(

				'slug' => 'slider'

			),

		)

	);

}



add_action('init', 'prefix_register_slider_post_type');



/**

 * Registers a metal fabrication custom taxonomy. 

 */

add_action( 'init', 'create_slider_taxonomies', 0 );

function create_slider_taxonomies() {

	// Add new taxonomy, make it hierarchical (like categories)

	$labels = array(

		'name'              => _x( 'Slider', 'taxonomy general name' ),

		'singular_name'     => _x( 'Slider', 'taxonomy singular name' ),

		

		'all_items'         => __( 'All Slider' ),

		'parent_item'       => __( 'Parent Slider' ),

		'parent_item_colon' => __( 'Parent Slider:' ),

		'edit_item'         => __( 'Edit Slider' ),

		'update_item'       => __( 'Update Slider' ),

		'add_new_item'      => __( 'Add New Slider' ),

		'new_item_name'     => __( 'New Slider Name' ),

		'menu_name'         => __( 'Slider Category' ),

	);



	$args = array(

		'hierarchical'      => true,

		'labels'            => $labels,

		'show_ui'           => true,

		'show_admin_column' => true,

		'query_var'         => true,

		'rewrite'           => array( 'slug' => 'slider', 'with_front' => FALSE )

	);



	register_taxonomy( 'slider', array( 'slider' ), $args );

}



?>