<?php

/*

 * 	Registers a service custom post type. 

 */

function prefix_register_post_type()

{

	register_post_type(

		'services',

		array(

			'labels'        => array(

			'name'               => __('Services', 'text_domain'),

			'singular_name'      => __('Service', 'text_domain'),

			'menu_name'          => __('Services', 'text_domain'),

			'name_admin_bar'     => __('Services', 'text_domain'),

			'all_items'          => __('All Services', 'text_domain'),

			'add_new'            => __('Add New Service', 'prefix_portfolio', 'text_domain'),

			'add_new_item'       => __('Add New Service Item', 'text_domain'),

			'edit_item'          => __('Edit Services Items', 'text_domain'),

			'new_item'           => __('New Service', 'text_domain'),

			'view_item'          => __('View Services', 'text_domain')

			),

			'public'        => true,

			'menu_position' => 5,

			//'register_meta_box_cb' => 'smashing_post_class_meta_box',

			'supports'      => array(

				'title',

				'editor',

				//'metabox',

				'thumbnail',

				'excerpt',

				'page-attributes',

				),

			

			'has_archive'   => true,

			'rewrite'       => array(

				'slug' => 'services'

			),

		)

	);

}



add_action('init', 'prefix_register_post_type');



/**

 * Registers a metal fabrication custom taxonomy. 

 */

add_action( 'init', 'create_services_taxonomies', 0 );





function create_services_taxonomies() {

	// Add new taxonomy, make it hierarchical (like categories)

	$labels = array(

		'name'              => _x( 'Services', 'taxonomy general name' ),

		'singular_name'     => _x( 'Service', 'taxonomy singular name' ),

		

		'all_items'         => __( 'All Services' ),

		'parent_item'       => __( 'Parent Service' ),

		'parent_item_colon' => __( 'Parent Service:' ),

		'edit_item'         => __( 'Edit Services' ),

		'update_item'       => __( 'Update Services' ),

		'add_new_item'      => __( 'Add New Service' ),

		'new_item_name'     => __( 'New Service Name' ),

		'menu_name'         => __( 'Service Category' ),

	);



	$args = array(

		'hierarchical'      => true,

		'labels'            => $labels,

		'show_ui'           => true,

		'show_admin_column' => true,

		'query_var'         => true,

		'rewrite'           => array( 'slug' => 'services', 'with_front' => FALSE )

	);



	register_taxonomy( 'services', array( 'services' ), $args );

}



?>