<?php

/*

 * 	Registers a service custom post type.

 */

function reviews_register_post_type()

{

	register_post_type(

		'reviews',

		array(

			'labels'        => array(

			'name'               => __('Reviews', 'text_domain'),

			'singular_name'      => __('Review', 'text_domain'),

			'menu_name'          => __('Reviews', 'text_domain'),

			'name_admin_bar'     => __('Reviews', 'text_domain'),

			'all_items'          => __('All Reviews', 'text_domain'),

			'add_new'            => __('Add New Reviews', 'prefix_portfolio', 'text_domain'),

			'add_new_item'       => __('Add New Reviews Item', 'text_domain'),

			'edit_item'          => __('Edit Reviews Items', 'text_domain'),

			'new_item'           => __('New Reviews', 'text_domain'),

			'view_item'          => __('View Reviews', 'text_domain')

			),

			'public'        => true,

			'menu_position' => 5,

			//'register_meta_box_cb' => 'smashing_post_class_meta_box',

			'supports'      => array(

				'title',

				'editor',

				//'metabox',

				'thumbnail',

				'excerpt',

				'page-attributes',

				),



			'has_archive'   => false,

			'rewrite'       => array(

				'slug' => 'reviews'

			),

		)

	);

}



add_action('init', 'reviews_register_post_type');



/**

 * Registers areviews custom taxonomy.

 */

add_action( 'init', 'create_reviews_taxonomies', 0 );





function create_reviews_taxonomies() {

	// Add new taxonomy, make it hierarchical (like categories)

	$labels = array(

		'name'              => _x( 'Reviews', 'taxonomy general name' ),

		'singular_name'     => _x( 'Review', 'taxonomy singular name' ),



		'all_items'         => __( 'All Reviews' ),

		'parent_item'       => __( 'Parent Reviews' ),

		'parent_item_colon' => __( 'Parent Reviews:' ),

		'edit_item'         => __( 'Edit Reviews' ),

		'update_item'       => __( 'Update Reviews' ),

		'add_new_item'      => __( 'Add New Reviews' ),

		'new_item_name'     => __( 'New Reviews Name' ),

		'menu_name'         => __( 'Reviews Category' ),

	);



	$args = array(

		'hierarchical'      => true,

		'labels'            => $labels,

		'show_ui'           => true,

		'show_admin_column' => true,

		'query_var'         => true,

		'rewrite'           => array( 'slug' => 'reviews', 'with_front' => FALSE )

	);



	register_taxonomy( 'reviews', array( 'reviews' ), $args );

}



?>
