<?php

	/**
	* Contacts widget
	*/
	class ContactsPart extends Wp_Widget
	{

		function __construct()
		{
			parent::__construct(
				'Contacts_part',
				__('Contact items'),
				array('description' => __('This widget is for showing contact information'))
			);
		}

		public function widget($args, $instance){
			$phone = apply_filters('phone', $instance['phone']);
			$email = apply_filters('email', $instance['email']);

			$img = get_template_directory_uri();

			$head_txt = get_permalink( get_page_by_path( 'tech-data/iso-9000' ) );

			echo '<div class="col-xs-6 col-sm-6 col-md-6 col-lg-6 title">
					<span class="headerStatement">Serving the design and engineering community for over 23 years.</span>
					<a href="'.$head_txt.'" class="productCopyWhite">3D-CAM, Inc. is AS 9100 Rev D & ISO 9001:2015 certified by BSI Management Systems America, Inc.</a>
		</div>
			<div class="col-xs-6 col-sm-3 col-md-3 col-lg-3 contact">';
				echo  !empty($phone) || !empty($email)  ?
					  '<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 phone">
					  		<p><img class="img-responsive" src="'.$img.'/images/header_phone.png" alt="phone">
					  		<span class="LatoSubHeadBlue">'.$phone.'</span></p>
					  </div>
					  <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 email">
					  		<p><img class="img-responsive" src="'.$img.'/images/header_letter.png" alt="letter">
					  		<a class="LatoSubHeadBlue" href="mailto:'.$email.'">'.$email.'</span></a></p>
					  </div>'
					  : null;
			echo '</div>';
		}

		public function form($instance){
			$phone = isset($instance['phone'] ) ? $instance['phone'] : '' ;
			$email = isset($instance['email'] ) ? $instance['email'] : '' ; ?>

			<div>
				<div>
					<label for="<?php echo $this->get_field_id( 'phone' ); ?>"><?php _e( 'Contact phone:'); ?></label>
					<input id="<?php echo $this->get_field_id( 'phone' ); ?>" name="<?php echo $this->get_field_name( 'phone' ); ?>"  value="<?php echo esc_attr( $phone ); ?>" style="width: 100%;">
				</div>
				<hr>
				<div>
					<label for="<?php echo $this->get_field_id( 'email' ); ?>"><?php _e( 'Contact email:'); ?></label>
					<input id="<?php echo $this->get_field_id( 'email' ); ?>" name="<?php echo $this->get_field_name( 'email' ); ?>"  value="<?php echo esc_attr( $email ); ?>" style="width: 100%;">
				</div>
			</div>

		<?php }

		public function update( $new_instance, $old_instance ) {
			$instance = array();
			$instance['phone'] = ( ! empty( $new_instance['phone'] ) ) ? strip_tags( $new_instance['phone'] ) : '';
			$instance['email'] = ( ! empty( $new_instance['email'] ) ) ? strip_tags( $new_instance['email'] ) : '';

			return $instance;
		}
	}

?>
