<?php 
add_action('add_meta_boxes' , 'services_meta_box_add');
    function services_meta_box_add() {  
    	add_meta_box(
        'services-post-class',      // Unique ID
         esc_html__( 'Homepage services row', 'example' ),    // Title
        'services_meta_box',   // Callback function
        'services',         // Admin page (or post type)
        'side',         // Context
        'core'         // Priority
    ); 
}

/* Display the post meta box. */
function services_meta_box() {  
    global $post;
    $values = get_post_custom($post->ID);
    $color1 = isset($values['gradient-color']) ? esc_attr($values['gradient-color'][0]) : '';
    $color2 = isset($values['gradient-color1']) ? esc_attr($values['gradient-color1'][0]) : '';
    $title = isset($values['header-title']) ? esc_attr($values['header-title'][0]) : '';
    $desc = isset($values['bottom-desc']) ? esc_attr($values['bottom-desc'][0]) : '';

    wp_nonce_field( 'services_meta_box_nonce', 'meta_box_nonce' );
?> 

<p>
    <label for="header-title">Title</label><br />    
    <input class="widefat" type="text" name="header-title" id="header-title" value="<?php echo $title; ?>">   
</p>

<p>
    <label for="gradient-color">Gradient top color</label><br />    
    <input class="widefat" type="color" name="gradient-color" id="gradient-color" value="<?php echo $color1; ?>">   
</p>
<p>
    <label for="gradient-color1">Gradient bottom color</label><br />    
    <input class="widefat" type="color" name="gradient-color1" id="gradient-color1" value="<?php echo $color2; ?>">   
</p>

<p>
    <label for="bottom-desc">Description</label><br />    
    <input class="widefat" type="text" name="bottom-desc" id="bottom-desc" value="<?php echo $desc; ?>">   
</p>

<?php } 

add_action( 'save_post', 'services_meta_box_save' ); 

function services_meta_box_save($post_id){

    if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;

    if( !isset( $_POST['meta_box_nonce'] ) || !wp_verify_nonce( $_POST['meta_box_nonce'], 'services_meta_box_nonce' ) ) return;

    if( !current_user_can( 'edit_post' ) ) return;

    if( isset( $_POST['gradient-color'] ) )
        update_post_meta( $post_id, 'gradient-color', wp_kses( $_POST['gradient-color'], $allowed ) );

    if( isset( $_POST['gradient-color1'] ) )
        update_post_meta( $post_id, 'gradient-color1', wp_kses( $_POST['gradient-color1'], $allowed ) );

    if( isset( $_POST['header-title'] ) )
        update_post_meta( $post_id, 'header-title', wp_kses( $_POST['header-title'], $allowed ) );

    if( isset( $_POST['gradient-color'] ) )
        update_post_meta( $post_id, 'bottom-desc', wp_kses( $_POST['bottom-desc'], $allowed ) );
}


?>