<?php

/*

 * 	Registers a projects custom post type. 

 */

function projects_register_post_type()

{

	register_post_type(

		'projects',

		array(

			'labels'        => array(

			'name'               => __('Projects', 'text_domain'),

			'singular_name'      => __('Project', 'text_domain'),

			'menu_name'          => __('Projects', 'text_domain'),

			'name_admin_bar'     => __('Projects', 'text_domain'),

			'all_items'          => __('All Projects', 'text_domain'),

			'add_new'            => __('Add New Project', 'prefix_portfolio', 'text_domain'),

			'add_new_item'       => __('Add New Projects Item', 'text_domain'),

			'edit_item'          => __('Edit Projects Items', 'text_domain'),

			'new_item'           => __('New Projects', 'text_domain'),

			'view_item'          => __('View Projects', 'text_domain')

			),

			'public'        => true,

			'menu_position' => 5,

			//'register_meta_box_cb' => 'smashing_post_class_meta_box',

			'supports'      => array(

				'title',

				'editor',

				//'metabox',

				'thumbnail',

				'excerpt',

				'page-attributes',

				),

			

			'has_archive'   => true,

			'rewrite'       => array(

				'slug' => 'projects'

			),

		)

	);

}



add_action('init', 'projects_register_post_type');



/**

 * Registers a metal fabrication custom taxonomy. 

 */

add_action( 'init', 'create_projects_taxonomies', 0 );





function create_projects_taxonomies() {

	// Add new taxonomy, make it hierarchical (like categories)

	$labels = array(

		'name'              => _x( 'Projects', 'taxonomy general name' ),

		'singular_name'     => _x( 'Project', 'taxonomy singular name' ),

		

		'all_items'         => __( 'All Projects' ),

		'parent_item'       => __( 'Parent Project' ),

		'parent_item_colon' => __( 'Parent Project:' ),

		'edit_item'         => __( 'Edit Projects' ),

		'update_item'       => __( 'Update Projects' ),

		'add_new_item'      => __( 'Add New Project' ),

		'new_item_name'     => __( 'New Project Name' ),

		'menu_name'         => __( 'Project Category' ),

	);



	$args = array(

		'hierarchical'      => true,

		'labels'            => $labels,

		'show_ui'           => true,

		'show_admin_column' => true,

		'query_var'         => true,

		'rewrite'           => array( 'slug' => 'projects', 'with_front' => FALSE )

	);



	register_taxonomy( 'projects', array( 'projects' ), $args );

}



?>