<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta name="description" content="<?php if(wp_title('')) { wp_title(''); echo ' | '; } bloginfo( 'description' ); ?>" />
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta http-equiv="X-UA-Compatible" content="IE=EmulateIE11">
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="google-site-verification" content="dPfJ5SAQR0HTbSfmeoZmJKBWKOGNDdGUrReIB__IW5Q" />
<title>
	<?php if ( is_category() ) {
	    echo 'Category Archive for &quot;'; single_cat_title(); echo '&quot; | '; bloginfo( 'name' );
	} elseif ( is_tag() ) {
	    echo 'Tag Archive for &quot;'; single_tag_title(); echo '&quot; | '; bloginfo( 'name' );
	} elseif ( is_archive() ) {
	    wp_title(''); echo ' Archive | '; bloginfo( 'name' );
	} elseif ( is_search() ) {
	    echo 'Search for &quot;'.esc_html($s).'&quot; | '; bloginfo( 'name' );
	} elseif ( is_home() ) {
	    bloginfo( 'name' );
	}  elseif ( is_404() ) {
	    echo 'Error 404 Not Found | '; bloginfo( 'name' );
	} elseif ( is_single() ) {
	    wp_title('');
	} else {
	    if(wp_title('', false)) {
	        echo wp_title('', false); echo ' | ';
	    }
	    bloginfo( 'name' );
	} ?>
</title>
	<?php wp_head(); ?>
<script>
  (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
  })(window,document,'script','https://www.google-analytics.com/analytics.js','ga');

  ga('create', 'UA-68179297-1', 'auto');
  ga('send', 'pageview');

</script>

<script type="text/javascript">
(function(a,e,c,f,g,h,b,d){var
k={ak:"963980250",cl:"JgFaCKmekmAQ2tfUywM",autoreplace:"(818)
773-8777"};a[c]=a[c]||function(){(a[c].q=a[c].q||[]).push(arguments)};a[g]||
(a[g]=k.ak);b=e.createElement(h);b.async=1;b.src="//www.gstatic.com/wcm/loader.js";d=e.getElementsByTagName(h)[0];d.parentNode.insertBefore(b,d);a[f]=function(b,d,e){a[c](2,b,k,d,null,new
Date,e)};a[f]()})(window,document,"_googWcmImpl","_googWcmGet","_googWcmAk","script");
</script>


</head>
<body>
<!--Skip to main content link.-->
<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', '3d-cam' ); ?></a>
<div id="content" class="hfeed site" tabindex="-1"></div>
<!--Skip to main content link.-->

<div class="cam-container tableGlow">
	<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 header-container">
		<div class="col-xs-6 col-sm-3 col-md-3 col-lg-3 logo">
			<?php if( get_header_image() ) : ?>
			    <a href="<?php echo esc_url(home_url('/')); ?>" title="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>" rel="home"><img src="<?php esc_url( header_image() ); ?>" alt="<?php echo esc_attr(get_bloginfo('name')) ?>" class="img-responsive" /></a>
			<?php else : ?>
			    <a href="<?php echo esc_url(home_url('/')); ?>" title="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>" rel="home"><img src="<?php echo THEME_BASE_URL.'images/logo.png' ?>" alt="<?php echo esc_attr(get_bloginfo('name')) ?>" class="img-responsive" /></a>

			<?php endif; ?>
		</div>
		<?php if ( is_active_sidebar( 'contacts' ) ) : ?>
		    <?php dynamic_sidebar( 'contacts' ); ?>
		<?php endif; ?>
	</div>
	<nav class="navbar navbar-default cam-navbar" id="menu" role="navigation">
      <div class="">
        <!-- Brand and toggle get grouped for better mobile display -->
        <div class="navbar-header">
            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1">
              <span class="sr-only">Toggle navigation</span>
              <span class="icon-bar"></span>
              <span class="icon-bar"></span>
              <span class="icon-bar"></span>
            </button>
        </div>
            <?php
                wp_nav_menu( array(
                    'menu'              => 'primary',
                    'theme_location'    => 'primary',
                    'depth'             =>  2,
                    'container'         => 'div',
                    'container_class'   => 'collapse navbar-collapse menu menu_black',
                    'container_id'      => 'bs-example-navbar-collapse-1',
                    'menu_class'        => 'nav navbar-nav NotationText',
                    'walker'            => new wp_bootstrap_navwalker())
                );
            ?>
        </div>
    </nav>
