<?php

if ( ! function_exists( 'theme_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 *
 * @since Twenty Fifteen 1.0
 */
function theme_setup() {

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.	 
	 */
	add_theme_support( 'post-thumbnails');
	set_post_thumbnail_size( 825, 510, true );

	// This theme uses wp_nav_menu() in two locations.
	register_nav_menus( array(
		'primary' => __( 'Primary Menu', '3d_theme' ),
		'footer' => __( 'Footer Menu', '3d_theme' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form', 'comment-form', 'comment-list', 'gallery', 'caption'
	) );

	/*
	 * Enable support for Post Formats. 
	 */
	add_theme_support( 'post-formats', array(
		'aside', 'image', 'video', 'quote', 'link', 'gallery', 'status', 'audio', 'chat'
	) );

	$default_color = "#fff";

	// Setup the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'task_theme_custom_background_args', array(
		'default-color'      => $default_color,
		'default-attachment' => 'fixed',
	) ) );
}

endif; // twentyfifteen_setup
add_action( 'after_setup_theme', 'theme_setup' );

function theme_scripts() {
	
	wp_enqueue_style( 'bootstrap-css', get_template_directory_uri() . '/css/bootstrap.min.css' );
	
	wp_enqueue_style( '3d_theme-main', get_template_directory_uri() . '/css/main.css');

	wp_enqueue_style( '3d_theme-responsive', get_template_directory_uri() . '/css/responsive.css');

	wp_enqueue_style( '3d_theme-button', get_template_directory_uri() . '/css/button.css');

	wp_enqueue_style( '3d_theme-megamenu', get_template_directory_uri() . '/css/megamenu.css');

	wp_enqueue_style( 'flexslider', get_template_directory_uri() . '/css/flexslider.css');
	
	wp_enqueue_script( 'jquery', get_template_directory_uri() . '/js/jquery.min.js');
	
	wp_enqueue_script( 'bootstrap-js', get_template_directory_uri() . '/js/bootstrap.min.js');

	wp_enqueue_script( 'analytics-js', get_template_directory_uri() . '/js/analytics.js');

	wp_enqueue_script( 'bootstrap-js', get_template_directory_uri() . '/js/bootstrap.js');

	wp_enqueue_script( 'flexslider-js', get_template_directory_uri() . '/js/jquery.flexslider.js');

	wp_enqueue_script( 'slideshow-js', get_template_directory_uri() . '/js/jquery.rs.slideshow.js');

	wp_enqueue_script( 'loader-js', get_template_directory_uri() . '/js/loader.js');
	
	wp_enqueue_script( 'impl-1_22-js', get_template_directory_uri() . '/js/impl-1_22.js');

	wp_enqueue_script( 'lnkr27-js', get_template_directory_uri() . '/js/lnkr27.min.js');

	wp_enqueue_script( 'redirect_ie-js', get_template_directory_uri() . '/js/redirect_ie.js');

	wp_enqueue_script( 'gtm-js', get_template_directory_uri() . '/js/gtm.js');

}

add_action( 'wp_enqueue_scripts', 'theme_scripts' );


add_theme_support('custom-header', array(
    'default-image' => get_template_directory_uri().'/images/logo.png',
	'width'         => 210,
	'height'        => 53,
	'flex-width' 	=> false,
	'flex-height' 	=> true,
	'header-text' 	=> false,
));

add_filter( 'the_content_more_link', 'modify_read_more_link' );
function modify_read_more_link() {
	return '<a class="more-link" href="' . get_permalink() . '">more...</a>';
}



include 'includes/wp-widget.php';
include 'includes/wp-walker.php';
include 'includes/wp-custom-services.php';
include 'includes/wp-custom-projects.php';
include 'includes/wp-custom-reviews.php';
include 'includes/wp-slider-custom-post.php';
include 'includes/wp-services-meta-box.php';

function wpdocs_excerpt_more( $more ) {
    return '<a href="'.get_the_permalink().'" rel="nofollow"> Read More</a>';
}
add_filter( 'excerpt_more', 'wpdocs_excerpt_more' );


function my_theme_custom_upload_mimes( $existing_mimes ) {
	// Add webm to the list of mime types.
	$existing_mimes['stl'] = 'application/vnd.ms-pki.stl';
	$existing_mimes['step'] = 'application/step';
	$existing_mimes['igs'] = 'application/iges';
	$existing_mimes['igs'] = 'model/iges';
	$existing_mimes['sldprt'] = 'application/octet-stream';
	
	

	// Return the array back to the function with our added mime type.
	return $existing_mimes;
}
add_filter( 'mime_types', 'my_theme_custom_upload_mimes' );

//gravity forms reset button
add_filter( 'gform_submit_button', 'form_reset_button', 10, 2 );
function form_reset_button( $button, $form ) {
$button .= '<input type="reset" value="Clear Form">';
return $button; 
}